﻿using System;
using System.Threading;

namespace CSharpBuch.Kap27
{
  class Aufgabe2
  {
    static void Main(string[] args)
    {
      Lager lager = new Lager();
      Thread produzent = new Thread(lager.Produzieren);
      Thread konsument = new Thread(lager.Entnehmen);
      produzent.Start();
      konsument.Start();
    }
  }

  class Lager
  {
    private int bestand;
    private int anzahl1;
    private int anzahl2;

    private Random rdn = new Random();

    public void Entnehmen()
    {
      for (; ; )
      {
        try
        {
          Monitor.Enter(this);
          anzahl1 = rdn.Next(100);
          while (bestand < anzahl1)
            Monitor.Wait(this);
          bestand -= anzahl1;
        }
        catch (Exception ex)
        {
          Console.WriteLine("Fehler: {0}", ex.Message);
        }
        finally
        {
          Monitor.Pulse(this);
          Monitor.Exit(this);
          Console.WriteLine("entnommen: -{0},\tneuer Bestand: {1}", anzahl1, bestand);
        }
        Thread.Sleep(1);
      }
    }

    public void Produzieren()
    {
      for (; ; )
      {
        try
        {
          Monitor.Enter(this);
          anzahl2 = rdn.Next(100);
          while ((bestand + anzahl2) > 10000)
            Monitor.Wait(this);
          bestand += anzahl2;
        }
        finally
        {
          Monitor.Pulse(this);
          Monitor.Exit(this);
          Console.WriteLine("produziert: {0},\tneuer Bestand: {1}", anzahl2, bestand);
        }
        Thread.Sleep(1);
      }
    }
  }
}